close all;
clear;
clc;
warning('off','all')
warning 
inputFolder = '../Raw Data/';
outputFolder = '../Processed Data/';
fileNames = extractfield(dir(strcat(inputFolder,'/P3BT*')),'name');

%for some devices a lower noise atributted to SiN residue in the bottom
%(Drain) electrode is observed, we use the Drain electrode signal for
%atucorrelation analysis in such cases.
SiNinSource = [false false true false true];
defaultFreq = 10e-6;

%High-pass filter cut-off frequencies in Hz selected for each case
stopFreqs = [1e-6 5e-6 5e-8 5e-8 0];
legendstr = strings(size(fileNames));

max_lag_value=0;
avg_authcorr_num=[];
avg_authcorr_denom=[];
avg_authcorr_lag=[];

for i = 1:length(fileNames)
    
    [I_Drain_pA, I_Source_pA, I_Ref_pA, t] = pAContinuousSignalImport(strcat(inputFolder, fileNames{i}));
    sampleF = 1/mean(diff(t)); % Average sample rate
    filtFreq = stopFreqs(i);
    
    detSource = mHzFilt(I_Source_pA, filtFreq, sampleF);
    detDrain = mHzFilt(I_Drain_pA, filtFreq, sampleF);
    detRef = mHzFilt(I_Ref_pA, filtFreq, sampleF);
    [wind_autocorrelation_dS, lag_dS] = xcorr(detSource - mean(detSource), 'unbiased');
    [wind_autocorrelation_dD, lag_dD] = xcorr(detDrain - mean(detDrain), 'unbiased');
    [wind_autocorrelation_dR, lag_dR] = xcorr(detRef - mean(detRef), 'unbiased');
    if(i==1)
        f = figure;
        f.WindowState = 'maximized';
    end
    
    wAdS = wind_autocorrelation_dS(floor(length(lag_dS))/2:end)/var(detSource);
    wAdD = wind_autocorrelation_dD(floor(length(lag_dD))/2:end)/var(detDrain);
    wAdR = wind_autocorrelation_dR(floor(length(lag_dR))/2:end)/var(detRef);
    
    ldS = lag_dS(floor(length(lag_dS))/2:end)/sampleF;
    ldD = lag_dD(floor(length(lag_dD))/2:end)/sampleF;
    ldR = lag_dR(floor(length(lag_dR))/2:end)/sampleF;
    
    if ~SiNinSource(i)
        wAdS=wAdD;
    end
    
    smlp=semilogx(ldS, wAdS);
    xlim([0.01 1000]);
    smlp(1).LineWidth = 1;
    legendstr(i) = extractAfter(fileNames{i},"P3BT_");
    xlabel('\tau (s)');
    ylabel('ACF');
    grid on;
    
    hold on

%% AVG autocorrelation
    if length(wAdS)>length(avg_authcorr_num)
        avg_authcorr_num(length(wAdS)) = 0;
        avg_authcorr_denom(length(wAdS)) = 0;
        avg_authcorr_lag = ldS;
    end
    
    avg_authcorr_num(1:length(wAdS)) = avg_authcorr_num(1:length(wAdS)) + wAdS'.*length(wAdS);
    avg_authcorr_denom(1:length(wAdS)) = avg_authcorr_denom(1:length(wAdS)) +length(wAdS);
    
end
legend(legendstr);
hold off;
saveas(f,strcat(outputFolder,'/SI Figure8.tif'));

f = figure;
f.WindowState = 'maximized';
avg_authcorr = avg_authcorr_num./avg_authcorr_denom;
semilogx(avg_authcorr_lag, avg_authcorr);
xlim([0.01 1000]);
xlabel('\tau (s)');
ylabel('Avg. ACF');

saveas(f,strcat(outputFolder,'/Figure5a.tif'));

